/****** OBJECT:  STOREDPROCEDURE [DBO].[P_CG_FND_VERBA_MOVIMENTACAO_USO_CONTRATO]    SCRIPT DATE: 04/08/2014 09:57:57 ******/
IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_CG_FND_VERBA_MOVIMENTACAO_USO_CONTRATO]') AND TYPE IN (N'P', N'PC'))
DROP PROCEDURE [DBO].[P_CG_FND_VERBA_MOVIMENTACAO_USO_CONTRATO]
GO
--P_CG_FND_VERBA_MOVIMENTACAO_USO_CONTRATO 1,162
CREATE PROCEDURE P_CG_FND_VERBA_MOVIMENTACAO_USO_CONTRATO(@CD_EMP INT, 
														  @CD_FND_VERBA INT,
														  @FLAG_LISTAR INT=0) WITH ENCRYPTION
AS
BEGIN
SET NOCOUNT ON
CREATE TABLE #RSDOCUMENTOS (
					   ORDEM INT IDENTITY (1, 1),
					   CD_FND_VERBA_USO INT,
					   CD_EMP INT,
					   CD_FILIAL INT,
					   CD_FILIAL_VD INT,
					   CD_VD INT,
					   CD_IT INT,
					   DS_TIPO_DOCUMENTO VARCHAR(40),
					   CD_PROD INT, 
					   DS_PROD VARCHAR(100),
					   NR_DOCUMENTO INT, 
					   DS_MOV VARCHAR (60), 
					   DT_MOV DATETIME, 
					   QT_IT MONEY, 
					   VLR_PROD_VERBA MONEY, 
					   VLR_LIMITE_VERBA_ORIGINAL MONEY,
					   VLR_LIMITE_VERBA MONEY,
					   VLR_VERBA_MOVIMENTO MONEY,
					   VLR_VERBA_USADA MONEY,
					   VLR_VERBA_SALDO MONEY)

DECLARE @VLR_LIMITE_CONTRATO MONEY
DECLARE @ORDEM INT
DECLARE @CD_PROD INT
DECLARE @VLR_VERBA MONEY
DECLARE @LIMITE_VERBA MONEY
DECLARE @LIMITE_VERBA_USO MONEY
DECLARE @LIMITE_VERBA_FALTA MONEY
DECLARE @CD_RECEITA INT
DECLARE @CD_FND_VERBA_SAQUE INT
DECLARE @VLR_SLD_ANT MONEY
DECLARE @CD_HIST INT

DECLARE @CD_PROD_PROC INT
DECLARE @VLR_VERBA_ATU MONEY
DECLARE @TP_CONTRATO INT


SELECT
	@TP_CONTRATO = TP_LANC
FROM
	CG_FND_VERBA
WHERE
	CD_EMP = @CD_EMP
	AND CD_FND_VERBA = @CD_FND_VERBA


IF @TP_CONTRATO = 1
BEGIN
	INSERT INTO
		#RSDOCUMENTOS
	SELECT
		CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA_USO,
		PDV_VD_IT.CD_EMP,
		CG_FND_VERBA.CD_FILIAL_FAT,
		PDV_VD_IT.CD_FILIAL,
		PDV_VD_IT.CD_VD,
		PDV_VD_IT.CD_IT,
		'USO DE VERBA (RECOMPOSICAO)',
		PDV_VD_IT.CD_PROD,
		EST_PROD.DS_PROD,
		PDV_VD.NR_ECF,
		'VENDAS AO CONSUMIDOR',
		PDV_VD.DT_VD,
		PDV_VD_IT.QT_IT,
		CG_FND_VERBA_USO_PROD.VLR_IT,
		VLR.VLR_SALDO AS LIMITE_VERBA,
		VLR.VLR_SALDO AS LIMITE_VERBA,
		(PDV_VD_IT.QT_IT * CG_FND_VERBA_USO_PROD.VLR_IT) AS VLR_VERBA_MOVIMENTO,
		(PDV_VD_IT.QT_IT * CG_FND_VERBA_USO_PROD.VLR_IT) AS VLR_VERBA_USADA,
		0
	FROM
		CG_FND_VERBA_USO_CG_FND_VERBA 
		INNER JOIN CG_FND_VERBA_LIB ON
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP = CG_FND_VERBA_LIB.CD_EMP
			AND CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_LIB.CD_FND_VERBA
		INNER JOIN CG_FND_VERBA_USO_PROD  ON
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP = CG_FND_VERBA_USO_PROD.CD_EMP AND
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA_USO = CG_FND_VERBA_USO_PROD.CD_FND_VERBA_USO
		INNER JOIN CG_FND_VERBA_USO  ON
			CG_FND_VERBA_USO_PROD.CD_EMP = CG_FND_VERBA_USO.CD_EMP AND
			CG_FND_VERBA_USO_PROD.CD_FND_VERBA_USO = CG_FND_VERBA_USO.CD_FND_VERBA_USO
		INNER JOIN CG_FND_VERBA ON
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP = CG_FND_VERBA.CD_EMP AND
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA.CD_FND_VERBA
		INNER JOIN CG_FND_VERBA_USO_PRC_FILIAL ON
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP = CG_FND_VERBA_USO_PRC_FILIAL.CD_EMP AND
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA_USO = CG_FND_VERBA_USO_PRC_FILIAL.CD_FND_VERBA_USO
		INNER JOIN PDV_VD_IT ON
			PDV_VD_IT.CD_EMP = CG_FND_VERBA_USO_PROD.CD_EMP AND
			PDV_VD_IT.CD_FILIAL = CG_FND_VERBA_USO_PRC_FILIAL.CD_FILIAL AND
			PDV_VD_IT.CD_PROD  = CG_FND_VERBA_USO_PROD.CD_PROD
		INNER JOIN PDV_VD ON
			PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP AND
			PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
			PDV_VD_IT.CD_VD = PDV_VD.CD_VD
		INNER JOIN EST_PROD ON
			PDV_VD_IT.CD_EMP = EST_PROD.CD_EMP AND
			PDV_VD_IT.CD_PROD = EST_PROD.CD_PROD
		INNER JOIN UFD_CG_FND_VERBA_RETORNA_VLR_PROD (@CD_EMP, @CD_FND_VERBA) VLR ON
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP = VLR.CD_EMP
			AND CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA = VLR.CD_FND_VERBA
			AND CG_FND_VERBA_USO_PROD.CD_PROD = VLR.CD_PROD
		INNER JOIN CG_FND_VERBA_GERACAO_PDV_VD_IT ON
			PDV_VD_IT.CD_EMP = CG_FND_VERBA_GERACAO_PDV_VD_IT.CD_EMP
			AND PDV_VD_IT.CD_FILIAL = CG_FND_VERBA_GERACAO_PDV_VD_IT.CD_FILIAL
			AND PDV_VD_IT.CD_VD = CG_FND_VERBA_GERACAO_PDV_VD_IT.CD_VD
			AND PDV_VD_IT.CD_IT = CG_FND_VERBA_GERACAO_PDV_VD_IT.CD_IT
			AND CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_GERACAO_PDV_VD_IT.CD_FND_VERBA
		LEFT OUTER JOIN CG_FND_VERBA_USO_PDV_VD_IT ON
			PDV_VD_IT.CD_EMP = CG_FND_VERBA_USO_PDV_VD_IT.CD_EMP AND
			PDV_VD_IT.CD_FILIAL = CG_FND_VERBA_USO_PDV_VD_IT.CD_FILIAL AND
			PDV_VD_IT.CD_VD = CG_FND_VERBA_USO_PDV_VD_IT.CD_VD AND
			PDV_VD_IT.CD_IT = CG_FND_VERBA_USO_PDV_VD_IT.CD_IT AND
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA_USO = CG_FND_VERBA_USO_PDV_VD_IT.CD_FND_VERBA_USO
	WHERE
		PDV_VD_IT.DT_VD BETWEEN CG_FND_VERBA_USO.DT_INI_APURACAO AND CG_FND_VERBA_USO.DT_FIM_APURACAO		
		AND PDV_VD_IT.CD_EMP=1
		AND CG_FND_VERBA.CD_FND_VERBA = @CD_FND_VERBA
		AND PDV_VD.ST_VD = 0
		AND PDV_VD_IT.ST_IT = 1
		AND VLR.VLR_SALDO > 0
		AND CG_FND_VERBA_USO_PDV_VD_IT.CD_IT IS NULL
		AND PDV_VD_IT.CD_FILIAL =  COALESCE(CG_FND_VERBA_USO_PRC_FILIAL.CD_FILIAL,0) 
	ORDER BY
		PDV_VD_IT.DT_VD,
		PDV_VD.HR_VD,
		PDV_VD_IT.CD_PROD
END 
ELSE
BEGIN
	INSERT INTO
		#RSDOCUMENTOS
	SELECT
		CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA_USO,
		PDV_VD_IT.CD_EMP,
		CG_FND_VERBA.CD_FILIAL_FAT,
		PDV_VD_IT.CD_FILIAL,
		PDV_VD_IT.CD_VD,
		PDV_VD_IT.CD_IT,
		'USO DE VERBA (RECOMPOSICAO)',
		PDV_VD_IT.CD_PROD,
		EST_PROD.DS_PROD,
		PDV_VD.NR_ECF,
		'VENDAS AO CONSUMIDOR',
		PDV_VD.DT_VD,
		PDV_VD_IT.QT_IT,
		CG_FND_VERBA_USO_PROD.VLR_IT,
		VLR.VLR_SALDO AS LIMITE_VERBA,
		VLR.VLR_SALDO AS LIMITE_VERBA,
		(PDV_VD_IT.QT_IT * CG_FND_VERBA_USO_PROD.VLR_IT) AS VLR_VERBA_MOVIMENTO,
		(PDV_VD_IT.QT_IT * CG_FND_VERBA_USO_PROD.VLR_IT) AS VLR_VERBA_USADA,
		0
	FROM
		CG_FND_VERBA_USO_CG_FND_VERBA 
		INNER JOIN CG_FND_VERBA_LIB ON
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP = CG_FND_VERBA_LIB.CD_EMP
			AND CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA_LIB.CD_FND_VERBA
		INNER JOIN CG_FND_VERBA_USO_PROD  ON
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP = CG_FND_VERBA_USO_PROD.CD_EMP AND
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA_USO = CG_FND_VERBA_USO_PROD.CD_FND_VERBA_USO
		INNER JOIN CG_FND_VERBA_USO  ON
			CG_FND_VERBA_USO_PROD.CD_EMP = CG_FND_VERBA_USO.CD_EMP AND
			CG_FND_VERBA_USO_PROD.CD_FND_VERBA_USO = CG_FND_VERBA_USO.CD_FND_VERBA_USO
		INNER JOIN CG_FND_VERBA ON
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP = CG_FND_VERBA.CD_EMP AND
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA = CG_FND_VERBA.CD_FND_VERBA
		INNER JOIN CG_FND_VERBA_USO_PRC_FILIAL ON
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP = CG_FND_VERBA_USO_PRC_FILIAL.CD_EMP AND
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA_USO = CG_FND_VERBA_USO_PRC_FILIAL.CD_FND_VERBA_USO
		INNER JOIN PDV_VD_IT ON
			PDV_VD_IT.CD_EMP = CG_FND_VERBA_USO_PROD.CD_EMP AND
			PDV_VD_IT.CD_FILIAL = CG_FND_VERBA_USO_PRC_FILIAL.CD_FILIAL AND
			PDV_VD_IT.CD_PROD  = CG_FND_VERBA_USO_PROD.CD_PROD
		INNER JOIN PDV_VD ON
			PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP AND
			PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
			PDV_VD_IT.CD_VD = PDV_VD.CD_VD
		INNER JOIN EST_PROD ON
			PDV_VD_IT.CD_EMP = EST_PROD.CD_EMP AND
			PDV_VD_IT.CD_PROD = EST_PROD.CD_PROD
		INNER JOIN UFD_CG_FND_VERBA_RETORNA_VLR_PROD (@CD_EMP, @CD_FND_VERBA) VLR ON
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_EMP = VLR.CD_EMP
			AND CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA = VLR.CD_FND_VERBA
			AND CG_FND_VERBA_USO_PROD.CD_PROD = VLR.CD_PROD
		LEFT OUTER JOIN CG_FND_VERBA_USO_PDV_VD_IT ON
			PDV_VD_IT.CD_EMP = CG_FND_VERBA_USO_PDV_VD_IT.CD_EMP AND
			PDV_VD_IT.CD_FILIAL = CG_FND_VERBA_USO_PDV_VD_IT.CD_FILIAL AND
			PDV_VD_IT.CD_VD = CG_FND_VERBA_USO_PDV_VD_IT.CD_VD AND
			PDV_VD_IT.CD_IT = CG_FND_VERBA_USO_PDV_VD_IT.CD_IT AND
			CG_FND_VERBA_USO_CG_FND_VERBA.CD_FND_VERBA_USO = CG_FND_VERBA_USO_PDV_VD_IT.CD_FND_VERBA_USO
	WHERE
		PDV_VD_IT.DT_VD BETWEEN CG_FND_VERBA_USO.DT_INI_APURACAO AND CG_FND_VERBA_USO.DT_FIM_APURACAO		
		AND CG_FND_VERBA.CD_FND_VERBA = @CD_FND_VERBA
		AND PDV_VD.ST_VD = 0
		AND PDV_VD_IT.CD_EMP=1
		AND PDV_VD_IT.ST_IT = 1
		AND VLR.VLR_SALDO > 0
		AND CG_FND_VERBA_USO_PDV_VD_IT.CD_IT IS NULL
		AND PDV_VD_IT.CD_FILIAL =  COALESCE(CG_FND_VERBA_USO_PRC_FILIAL.CD_FILIAL,0) 
	ORDER BY
		PDV_VD_IT.DT_VD,
		PDV_VD.HR_VD,
		PDV_VD_IT.CD_PROD
END
		

	DECLARE CALCVERBAUSO CURSOR FAST_FORWARD FOR 
	SELECT 
		ORDEM,
		CD_PROD,
		VLR_VERBA_MOVIMENTO,
		VLR_LIMITE_VERBA
	FROM 
		#RSDOCUMENTOS
	ORDER BY
		CD_PROD,
		ORDEM
				
	OPEN CALCVERBAUSO

	SET @VLR_VERBA_ATU = 0
	SET @LIMITE_VERBA_USO = 0
	SET @CD_PROD_PROC = 0

	FETCH NEXT FROM CALCVERBAUSO INTO @ORDEM, @CD_PROD, @VLR_VERBA, @LIMITE_VERBA
	WHILE @@FETCH_STATUS=0
		BEGIN
			IF @CD_PROD <> @CD_PROD_PROC 
				BEGIN
					SET @VLR_VERBA_ATU = 0
					SET @LIMITE_VERBA_USO = 0
				END

			SET @CD_PROD_PROC = @CD_PROD
			
			SET @LIMITE_VERBA_FALTA = @LIMITE_VERBA - @LIMITE_VERBA_USO

			IF @LIMITE_VERBA_FALTA > @VLR_VERBA AND @LIMITE_VERBA_FALTA > 0
				BEGIN
					IF @LIMITE_VERBA_FALTA > 0
						BEGIN
							IF @LIMITE_VERBA_FALTA > @VLR_VERBA
								BEGIN
									SET @VLR_VERBA_ATU = @VLR_VERBA
								END
							ELSE
								BEGIN
									SET @VLR_VERBA_ATU = @LIMITE_VERBA_FALTA
								END
						END
					ELSE
						BEGIN
							SET @VLR_VERBA_ATU=0
						END	

					IF @LIMITE_VERBA_FALTA > 0
						BEGIN	
							SET @LIMITE_VERBA_USO = @LIMITE_VERBA_USO + @VLR_VERBA_ATU 
					
							UPDATE 
								#RSDOCUMENTOS 
							SET 
								VLR_VERBA_USADA = @VLR_VERBA_ATU,
								VLR_VERBA_SALDO = @LIMITE_VERBA-@LIMITE_VERBA_USO
							WHERE
								ORDEM = @ORDEM								
						END
				END
			ELSE
				BEGIN
					UPDATE 
						#RSDOCUMENTOS 
					SET 
						VLR_VERBA_USADA = CASE WHEN @LIMITE_VERBA_FALTA > @LIMITE_VERBA THEN @LIMITE_VERBA ELSE @LIMITE_VERBA_FALTA END,
						VLR_VERBA_SALDO = 0
					WHERE
						ORDEM = @ORDEM

					DELETE
						#RSDOCUMENTOS 
					WHERE 
						ORDEM > @ORDEM 
						AND CD_PROD = @CD_PROD
				END
			--PROXIMO REGISTRO
			FETCH NEXT FROM CALCVERBAUSO INTO @ORDEM,@CD_PROD, @VLR_VERBA, @LIMITE_VERBA
		END

	--FECHANDO CURSOS
	CLOSE CALCVERBAUSO;
	--DESALOCANDO CURSOS DA MEMORIA
	DEALLOCATE CALCVERBAUSO;

BEGIN TRAN

BEGIN TRY

	IF EXISTS (SELECT * FROM #RSDOCUMENTOS)
	BEGIN
		PRINT 'Vinculando vendas ao contrato de verba usadas ' +  (CONVERT(VARCHAR(8), GETDATE(),108));		
		INSERT INTO 
			CG_FND_VERBA_USO_PDV_VD_IT (CD_EMP, CD_FND_VERBA_USO, CD_FILIAL, CD_VD, CD_IT, VLR_USO, CD_PROD)
		SELECT
			CD_EMP,
			CD_FND_VERBA_USO,
			CD_FILIAL_VD,
			CD_VD,
			CD_IT,
			VLR_VERBA_USADA,
			CD_PROD
		FROM
			#RSDOCUMENTOS

		PRINT 'Alterando vendas recomposta ' +  (CONVERT(VARCHAR(8), GETDATE(),108));		
		UPDATE
			V
		SET
			V.VLR_RECOMPOSICAO_MARGEM = ISNULL(V.VLR_RECOMPOSICAO_MARGEM,0) + R.VLR_VERBA_USADA
		FROM
			PDV_VD_IT V
			INNER JOIN #RSDOCUMENTOS R ON
				V.CD_EMP = R.CD_EMP AND
				V.CD_FILIAL = R.CD_FILIAL_VD AND
				V.CD_VD = R.CD_VD AND
				V.CD_IT = R.CD_IT

		PRINT 'Gravando historico de uso ' +  (CONVERT(VARCHAR(8), GETDATE(),108));		
		SELECT @CD_HIST = COALESCE(MAX(CD_HIST),0) + 1 FROM CG_FND_VERBA_HIST
		INSERT INTO
			CG_FND_VERBA_HIST (CD_HIST, CD_EMP, CD_FND_VERBA, TP_HIST, DS_HIST, CD_USU, DT_HIST, HR_HIST)
		VALUES
			(@CD_HIST, @CD_EMP, @CD_FND_VERBA, 'ALOCACAO', 'ALOCACAO DE VERBA', 1, GETDATE(), GETDATE())
	END
END TRY

BEGIN CATCH
	RAISERROR ('P_CG_FND_VERBA_MOVIMENTACAO_USO_CONTRATO - GRAVACAO DO USO DA VERBA.',16, 1);
	ROLLBACK TRANSACTION;
	RETURN;
END CATCH

SET @CD_RECEITA = 0
SELECT @CD_RECEITA = VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'CD_RECEITA_VERBA_GERENCIAL'

IF @CD_RECEITA = 0
BEGIN
	RAISERROR ('P_CG_FND_VERBA_MOVIMENTACAO_USO_CONTRATO - CODIGO DA RECEITA PARA LANCAMENTO DO CONTAS A RECEBER NAO ENCONTRADO.',16, 1);
	ROLLBACK TRANSACTION;
	RETURN;
END


BEGIN TRY
	IF EXISTS (SELECT * FROM #RSDOCUMENTOS)
	BEGIN
		SET @VLR_VERBA = 0;

		SELECT @VLR_VERBA = SUM(VLR_VERBA_USADA) FROM #RSDOCUMENTOS
		SELECT @CD_FND_VERBA_SAQUE = COALESCE(MAX(CD_FND_VERBA_SAQUE), 0) + 1 FROM CG_FND_VERBA_SAQUE WHERE CD_EMP = @CD_EMP AND CD_FND_VERBA = @CD_FND_VERBA
		SELECT @VLR_SLD_ANT = COALESCE(SUM(VLR_SAQUE),0) FROM CG_FND_VERBA_SAQUE WHERE CD_EMP = @CD_EMP AND CD_FND_VERBA = CD_FND_VERBA
		PRINT 'Gravando saque ' +  (CONVERT(VARCHAR(8), GETDATE(),108));	
		INSERT INTO
			CG_FND_VERBA_SAQUE (CD_EMP, CD_FND_VERBA, CD_FND_VERBA_SAQUE, CD_DESP_REC, HIST_SAQ, DT_SAQUE, STATUS, VLR_SAQUE, SALDO_ANT, DT_CAD, CD_USU)
		VALUES
			(@CD_EMP, @CD_FND_VERBA, @CD_FND_VERBA_SAQUE, @CD_RECEITA, 'ALOCACAO DE VERBA NO CONTRATO: ' + CAST(@CD_FND_VERBA AS VARCHAR), CONVERT(DATE, GETDATE()), 0, @VLR_VERBA, @VLR_SLD_ANT, CONVERT(DATE, GETDATE()), 1)
		
		PRINT 'Vinculo da venda com o saque ' +  (CONVERT(VARCHAR(8), GETDATE(),108));	
		INSERT INTO
			CG_FND_VERBA_SAQUE_CG_FND_VERBA_USO_PDV_VD_IT(CD_EMP, CD_FND_VERBA_USO, CD_FILIAL, CD_VD, CD_IT, CD_FND_VERBA_SAQUE, CD_FND_VERBA)
		SELECT
			CD_EMP,
			CD_FND_VERBA_USO,
			CD_FILIAL_VD,
			CD_VD,
			CD_IT,
			@CD_FND_VERBA_SAQUE,
			@CD_FND_VERBA
		FROM
			#RSDOCUMENTOS
	END
END TRY

BEGIN CATCH
	RAISERROR ('P_CG_FND_VERBA_MOVIMENTACAO_USO_CONTRATO - GRAVACAO DO VALOR DO SAQUE.',16, 1);
	ROLLBACK TRANSACTION;
	RETURN;
END CATCH

COMMIT;
IF @FLAG_LISTAR=1
BEGIN
	SELECT * FROM #RSDOCUMENTOS ORDER BY CD_PROD
END
DROP TABLE #RSDOCUMENTOS
RETURN
END

